package examples.messaging;

import javax.jms.*;
import javax.ejb.*;
import javax.annotation.PreDestroy;

@MessageDriven(activationConfig = { 
        @ActivationConfigProperty(propertyName = "destinationType", 
                propertyValue = "javax.jms.Topic") 
        })
public class LogBean implements MessageListener {
    
    public LogBean() {
        System.out.println("LogBean created");
    }
    
    public void onMessage(Message msg) {
        if (msg instanceof TextMessage) {
            TextMessage tm = (TextMessage) msg;
            try {
                String text = tm.getText();
                System.out.println("Received new message : " + text);
            } catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }
    
    @PreDestroy
    public void remove() {
        System.out.println("LogBean destroyed.");
    }
}